rm(list=ls())
library(copula)
library(readxl)
library(xtable)
library(openxlsx)


ATT<-function(lam11,lam12,t,tau)
{
  if(theta>=0)
  {
    Fvar<-function(t)
    {-1+exp(-t/lam1)+exp(-t/lam2)+((1-exp(-t/lam1))^(-theta)+(1-exp(-t/lam2))^(-theta)-1)^(-1/theta)}
  } else {Fvar<-function(t)
  {-1+exp(-t/lam1)+exp(-t/lam2)+(max(0,(1-exp(-t/lam1))^(-theta)+(1-exp(-t/lam2))^(-theta)-1))^(-1/theta)}}
  A=integrate(Fvar,0,+Inf)
  ET<-A$value
  alpha<-ET/370
  alpha1<-alpha*t/100
  alpha2<-alpha-alpha1
  ###### Calculating of LCL for downward shifts
  if(theta<0) 
    LCL<-uniroot(function(t)   2-exp(-t/lam1)-exp(-t/lam2)-alpha1 , lower = 0, upper = 10)$ root
  
  if(theta>=0)
    LCL<-uniroot(function(t) 2-exp(-t/lam1)-exp(-t/lam2)-((1-exp(-t/lam1))^(-theta)+(1-exp(-t/lam2))^(-theta)-1)^(-1/theta)-alpha1 , lower = 0, upper = 1000)$ root
  ###### Calculating of LCL for downward shifts
  UCL<-uniroot(function(t) 2-exp(-t/lam1)-exp(-t/lam2)-((1-exp(-t/lam1))^(-theta)+(1-exp(-t/lam2))^(-theta)-1)^(-1/theta)+alpha2-1 ,
               lower = 2, upper = 1000)$ root
  
  #### Calculating the type II error
  
  F<-function(lam1,lam2,t)
  {
    2-exp(-t/lam1)-exp(-t/lam2)- max(0,((1-exp(-t/lam1))^(-theta)+(1-exp(-t/lam2))^(-theta)-1))^(-1/theta)
  }
  
  beta<-F(lam11,lam12,UCL)-F(lam11,lam12,LCL)
  if(theta>=0)
  {
    Fvar<-function(t)
    {-1+exp(-t/lam11)+exp(-t/lam12)+((1-exp(-t/lam11))^(-theta)+(1-exp(-t/lam12))^(-theta)-1)^(-1/theta)}
  } else {Fvar<-function(t)
  {-1+exp(-t/lam11)+exp(-t/lam12)+(max(0,(1-exp(-t/lam11))^(-theta)+(1-exp(-t/lam12))^(-theta)-1))^(-1/theta)}}
  A=integrate(Fvar,0,+Inf)
  ET1<-A$value
  ATS1<-(1/(1-beta))*ET1
  
  return(ATS1)
}

#################################
t<-seq(1,100,1)
par<-read_excel("D:\\parametrs.xlsx")
tau=-0.75   # dependence parameter
result<-matrix(NA,ncol=100,nrow=35)
alphares<-matrix(NA,ncol=2,nrow=100)
theta<-iTau(claytonCopula(dim=2),tau=tau)

lam1<-1
lam2<-1

lam11<-par[[5]]*lam1    # out-control parameter of first variable
lam12<-par[[6]]*lam2 

for(m in 1:100)
  
{
  q<-0
  #####################################
  if(theta>=0)
  {
    Fvar<-function(t)
    {-1+exp(-t/lam1)+exp(-t/lam2)+((1-exp(-t/lam1))^(-theta)+(1-exp(-t/lam2))^(-theta)-1)^(-1/theta)}
  } else {Fvar<-function(t)
  {-1+exp(-t/lam1)+exp(-t/lam2)+(max(0,(1-exp(-t/lam1))^(-theta)+(1-exp(-t/lam2))^(-theta)-1))^(-1/theta)}}
  A=integrate(Fvar,0,+Inf)
  ET<-A$value
  alpha<-ET/370
  alpha1<-alpha*t[m]/100
  alpha2<-alpha-alpha1
  ###### Calculating of LCL for downward shifts
  if(theta<0) 
    LCL<-uniroot(function(t)   2-exp(-t/lam1)-exp(-t/lam2)-alpha1 , lower = 0, upper = 10)$ root
  
  if(theta>=0)
    LCL<-uniroot(function(t) 2-exp(-t/lam1)-exp(-t/lam2)-((1-exp(-t/lam1))^(-theta)+(1-exp(-t/lam2))^(-theta)-1)^(-1/theta)-alpha1 , lower = 0, upper = 1000)$ root
  ###### Calculating of LCL for downward shifts
  UCL<-uniroot(function(t) 2-exp(-t/lam1)-exp(-t/lam2)-((1-exp(-t/lam1))^(-theta)+(1-exp(-t/lam2))^(-theta)-1)^(-1/theta)+alpha2-1 ,
               lower = 2, upper = 1000)$ root
  
    ############################# 
  for (j in 1:30)
  {
    
    ATT1<-ATT(lam11[j],lam12[j],t=t[m],tau)
    
    result[j,m]<-ATT1
    if(ATT1>370)
    {
      q<-q+1
    }
    
  }
  alphares[m,]<-c(m,q)
  result[31,m]=LCL
  result[32,m]=UCL
  result[33,m]=ET
  result[34,m]=alpha1
  result[35,m]=alpha2
}

#t<-seq(0.01,1,0.01)
#plot(t,result,type="o",ylab="ATS",xlab="t")
alphares

write.xlsx(result, file = "D:\\res.xlsx",
           sheetName = "result", append = FALSE)

